//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;

import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 6-1, Getting the Data Type of a Source, in
 * Chapter 6, Understanding Source  Objects, in the Oracle OLAP Developer's
 * Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 */
public class GettingDataTypeOfSource
{

  public GettingDataTypeOfSource()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, true);
    DataProvider dp = context.getDataProvider();

    context.println("Example 6-1, Getting the Data Type of "
                    + "a Source\n");

    MdmPrimaryDimension mdmProdDim =
                          context.getMdmPrimaryDimensionByName("PRODUCT");

    FundamentalMetadataProvider fmp = dp.getFundamentalMetadataProvider();
    FundamentalMetadataObject fmoStringDataType = fmp.getStringDataType();
    Source stringDataTypeSource = fmoStringDataType.getSource();
    FundamentalMetadataObject fmoMdmProdDimDataType =
                                               mdmProdDim.getDataType();
    Source mdmProdDimDataTypeSource = fmoMdmProdDimDataType.getSource();
    Source prodDim = mdmProdDim.getSource();
    Source prodDimDataTypeSource = prodDim.getDataType();
    if(stringDataTypeSource == prodDimDataTypeSource &&
       mdmProdDimDataTypeSource == prodDimDataTypeSource)
    {
      System.out.println("The Source objects for the data types are all the " +
                     "same.");
    }
    else
    {  System.out.println("The Source objects for the data types are not " +
                         "all the same.");
    }
  }


  public static void main(String[] args)
  {
    new GettingDataTypeOfSource().run(args);
  }
}
